package netsdk.lib;

import java.util.List;

import com.sun.jna.IntegerType;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;

import netsdk.callback.*;
import netsdk.struct.*;



public interface DeviceSdk extends Library {
//	DeviceSdk INSTANCE = (DeviceSdk) Native.loadLibrary("F:\\code\\pingtai\\SDK\\Release_vcx_x64\\DVR_NET_SDK", DeviceSdk.class);
	//DeviceSdk INSTANCE = (DeviceSdk) Native.loadLibrary("E:\\设备SDK测试\\SDK-N9000\\Windows\\c# wrapper\\DevSdkByCS_win64\\Demo\\bin\\x64\\Release\\DVR_NET_SDK.dll", DeviceSdk.class);
	DeviceSdk INSTANCE = (DeviceSdk) Native.loadLibrary("D:\\SDK-N9000\\NetSdk\\Windows\\bin_release\\Release_vcx_x64\\DVR_NET_SDK.dll", DeviceSdk.class);
	
	//DeviceSdk INSTANCE = (DeviceSdk) Native.loadLibrary("dvrnetsdk", DeviceSdk.class);
	
	//获取SDK的版本信息
    int NET_SDK_GetSDKVersion();
  //获取SDK的版本号和build信息
    int NET_SDK_GetSDKBuildVersion();
	// SDK初始化及退出
	boolean NET_SDK_Init();
	boolean NET_SDK_Cleanup();
	// 设置重连参数
	boolean NET_SDK_SetConnectTime(long dwWaitTime, int dwTryTimes);
	boolean NET_SDK_SetReconnect(int dwInterval, boolean bEnableRecon);
	//搜索局域网内设备
	int NET_SDK_DiscoverDevice(Pointer pDeviceInfo, int bufNum,int waitSeconds);
	// SDK被动接收DVR注册 的本地端口号
	boolean NET_SDK_SetRegisterPort(int wRegisterPort,Pointer pt,int num);
	boolean NET_SDK_SetRegisterCallback(ACCEPT_REGISTER_CALLBACK fRegisterCBFun, Pointer pUser);
	//添加主动注册设备的信息
    boolean NET_SDK_AddRegisterDeviceInfo(Pointer pLoginInfo, int deviceNum);
	// 异常消息回调函数
	boolean NET_SDK_SetSDKMessageCallBack(int nMessage, Pointer hWnd, EXCEPTION_CALLBACK fExceptionCallBack,
			Pointer pUser);
	// 错误查询
	int NET_SDK_GetLastError();
	// 登录登出设备
	NativeLong NET_SDK_Login(String sDVRIP, int wDVRPort, String sUserName, String sPassword,
			LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo);
	NativeLong NET_SDK_LoginEx(String sDVRIP, int wDVRPort, String sUserName, String sPassword,
			LPNET_SDK_DEVICEINFO.ByReference lpDeviceInfo, int eConnectType, String sDevSN);
	boolean NET_SDK_Logout(NativeLong lUserID);
	// 设备报警或状态回调
	boolean NET_SDK_SetDVRMessageCallBack(NET_MESSAGE_CALLBACK fMessageCallBack, Pointer pUser);
	NativeLong NET_SDK_SetupAlarmChan(NativeLong lUserID);
	boolean NET_SDK_CloseAlarmChan(NativeLong lAlarmHandle);
	// 主动查询当前报警信息：N9000当前报警， IPC，3.0设备主动上报的报警
	boolean NET_SDK_GetAlarmStatus(NativeLong lUserID, Pointer lpOutBuffer, int dwOutBufferSize, IntByReference lpBytesReturned);
	
	boolean NET_SDK_SetDeviceManualAlarm(NativeLong lUserID, int[] pAramChannel, int[] pValue, int lAramChannelCount, boolean bAlarmOpen);
	// //////////////////////////////////////获取设备信息////////////////////////////////////////
	boolean NET_SDK_GetDeviceInfo(NativeLong lUserID, LPNET_SDK_DEVICEINFO.ByReference pdecviceInfo);
	boolean NET_SDK_GetDeviceTime(NativeLong lUserID, DD_TIME.ByReference pTime);// 获取设备当前时间
	boolean NET_SDK_GetDeviceCHStatus(NativeLong lUserID, Pointer pDeviceCHStatus,NativeLong lBuffSize, IntByReference pCHCount);// 获取NVR的通道状态
	boolean NET_SDK_GetDeviceIPCInfo(NativeLong lUserID, Pointer pDeviceIPCInfo, NativeLong lBuffSize, IntByReference pCHCount);
    
	// //////////////////////////////////////预览相关接口////////////////////////////////////////
	NativeLong NET_SDK_LivePlay(NativeLong lUserID, LPNET_SDK_CLIENTINFO.ByReference lpClientInfo,
			LIVE_DATA_CALLBACK fLiveDataCallBack, Pointer pUser);
	boolean NET_SDK_StopLivePlay(NativeLong lLiveHandle);
	boolean NET_SDK_SetLiveDataCallBack(NativeLong lLiveHandle, LIVE_DATA_CALLBACK fLiveDataCallBack, Pointer pUser);
	
	boolean NET_SDK_SaveLiveData(NativeLong lLiveHandle,String sFileName);
	boolean NET_SDK_StopSaveLiveData(NativeLong lLiveHandle);
	//预览抓图
	boolean NET_SDK_CapturePicture(NativeLong lLiveHandle,String sPicFileName);
	//不开启预览抓图		
	boolean NET_SDK_CaptureJpeg(NativeLong lUserID, int lChannel,int dwResolutionString, Pointer  sJpegPicBuffer,int dwPicBufSize, IntByReference lpSizeReturned);
	
	boolean NET_SDK_RemoteSnap(NativeLong lUserID, int lChannel);
	
	boolean NET_SDK_SearchPictures(NativeLong lUserID,NET_SDK_IMAGE_SREACH sInSreachImage,int lInImageBufferSize,
			 Pointer pOutImageInfo,IntByReference pOutImageNum);
	boolean NET_SDK_DownLoadPicture(NativeLong lUserID, NET_SDK_IMAGE captureImage, NET_SDK_IMAGE_INFO.ByReference pOutImageInfo, 
			Pointer pOutBuffer, int outBufferSize);

	//预览开启音频
	boolean NET_SDK_OpenSound(NativeLong lLiveHandle);
	//预览关闭音频
	boolean NET_SDK_CloseSound();
	//调整音量
	boolean NET_SDK_Volume(NativeLong lLiveHandle,short wVolume);
	// 根据文件时间查找录像文件
	NativeLong NET_SDK_FindFile(NativeLong lUserID, int lChannel, DD_TIME.ByReference lpStartTime, DD_TIME.ByReference lpStopTime);
	int NET_SDK_FindNextFile(NativeLong lFindHandle, NET_SDK_REC_FILE.ByReference lpFindData);
	boolean NET_SDK_FindClose(NativeLong lFindHandle);
	//查找有录像的日期
	NativeLong NET_SDK_FindRecDate(NativeLong lUserID);
	int NET_SDK_FindNextRecDate(NativeLong lFindHandle, DD_DATE.ByReference lpRecDate);
	boolean NET_SDK_FindRecDateClose(NativeLong lFindHandle);
	//根据事件类型查找录像文件
	NativeLong NET_SDK_FindEvent(NativeLong lUserID,int lChannel,int dwRecType,DD_TIME.ByReference lpStartTime,DD_TIME.ByReference lpStopTime);
	int NET_SDK_FindNextEvent(NativeLong lFindHandle,NET_SDK_REC_EVENT.ByReference lpRecEvent);
	boolean NET_SDK_FindEventClose(NativeLong lFindHandle);
	//根据时间查找录像
	NativeLong NET_SDK_FindTime(NativeLong lUserID,int lChannel, DD_TIME.ByReference lpStartTime, DD_TIME.ByReference lpStopTime);
	int NET_SDK_FindNextTime(NativeLong lFindHandle,NET_SDK_REC_TIME.ByReference lpFindData);
	boolean NET_SDK_FindTimeClose(NativeLong lFindHandle);
	// 下载录像文件
	NativeLong NET_SDK_GetFileByTime(NativeLong lUserID, NativeLong lChannel, DD_TIME.ByReference lpStartTime, DD_TIME.ByReference lpStopTime,
			String sSavedFileName);
	// 下载录像文件扩展
	NativeLong NET_SDK_GetFileByTimeEx(NativeLong lUserID, int lChannel, DD_TIME lpStartTime, DD_TIME lpStopTime,
			String sSavedFileName, boolean bCustomFormat, boolean bUseCallBack, BACKUP_DATA_CALLBACK fBackupDataCallBack, Pointer pUser); //bCustomFormat：1-使用私有文件格式 0-avi格式 
	NativeLong NET_SDK_GetFileByTimeExV2(NativeLong lUserID, int lChannel, DD_TIME lpStartTime, DD_TIME lpStopTime,
			String sSavedFileName, byte recFormat, boolean bFirstStream, boolean bUseCallBack, BACKUP_DATA_CALLBACK fBackupDataCallBack, Pointer pUser);
	
	boolean NET_SDK_StopGetFile(NativeLong lFileHandle);
	int NET_SDK_GetDownloadPos(NativeLong lFileHandle);
	//录像回放
	NativeLong NET_SDK_PlayBackByTime(NativeLong lUserID, int[] lChannels, int channelNum, DD_TIME lpStartTime, 
			DD_TIME lpStopTime, Pointer[] hWnds);
	NativeLong NET_SDK_PlayBackByTimeEx(NativeLong lUserID, int[] lChannels, int channelNum, DD_TIME lpStartTime, 
			DD_TIME lpStopTime, Pointer[] hWnds,boolean bFirstStream);
	int NET_SDK_PlayBackByTimeSync(NativeLong lUserID, int[] pChannels, int channelNum, DD_TIME lpStartTime, 
			DD_TIME lpStopTime, Pointer[] hWnds, boolean bFirstStream);
	boolean NET_SDK_PlayBackControl(NativeLong playHandle, int dwControlCode, int dwInValue, int[] lpOutValue);
	boolean NET_SDK_PlayBackControlSync(int dwControlCode,int dwInValue,Pointer lpOutValue);
	boolean NET_SDK_StopPlayBack(NativeLong playHandle);
	
	
	boolean NET_SDK_SetPlayDataCallBack(NativeLong playHandle, PLAY_DATA_CALLBACK fPlayDataCallBack, Pointer pUser);
	boolean NET_SDK_PlayBackSaveData(NativeLong lPlayHandle, int lChannel, String sFileName);
	boolean NET_SDK_StopPlayBackSave(NativeLong lPlayHandle, int lChannel);
	
	boolean NET_SDK_GetPlayBackOsdTime(NativeLong lPlayHandle, DD_TIME.ByReference lpOsdTime);
	boolean NET_SDK_RefreshPlay(NativeLong lPlayHandle);
	boolean NET_SDK_PlayBackCaptureFile(NativeLong lPlayHandle, int lChannel, String sFileName);
	
	boolean NET_SDK_StartDVRRecord(NativeLong lUserID, int lChannel, int lRecordType);
	boolean NET_SDK_StopDVRRecord(NativeLong lUserID, int lChannel);
	
	// FaceMatch NET_SDK_FACE_MATCH_OPERATE_TYPE
	public enum _net_sdk_face_match_operate_type
	{
		NET_SDK_GET_BEGIN,//invalid command 值为0
	    NET_SDK_GET_FACE_MATCH_SUPPORT,//in:NULL, out:DWORD  值为1下面的依次递增
	    //目标组
	    NET_SDK_GET_FACE_INFO_GROUP_LIST,//queryFacePersonnalInfoGroupList in:NULL, out:NET_SDK_FACE_INFO_GROUP_ITEM list
	    NET_SDK_ADD_FACE_INFO_GROUP,//createFacePersonnalInfoGroup in:NET_SDK_FACE_INFO_GROUP_ADD out:NULL
	    NET_SDK_SET_FACE_INFO_GROUP,//editFacePersonnalInfoGroup in:NET_SDK_FACE_INFO_GROUP_ITEM  out:NULL
	    NET_SDK_DEL_FACE_INFO_GROUP,//delFacePersonnalInfoGroups in:NET_SDK_FACE_INFO_GROUP_DEL  out:NULL
	    //目标
	    NET_SDK_GET_FACE_INFO_LIST,//queryFacePersonnalInfoList in:NET_SDK_FACE_INFO_LIST_GET, out:NET_SDK_FACE_INFO_LIST
	    NET_SDK_ADD_FACE_INFO,//createFacePersonnalInfo in:NET_SDK_FACE_INFO_ADD out:NULL
	    NET_SDK_SET_FACE_INFO,//editFacePersonnalInfo in:NET_SDK_FACE_INFO_EDIT out:NULL
	    NET_SDK_DEL_FACE_INFO,//delFacePersonnalInfo in:NET_SDK_FACE_INFO_DEL  out:NULL
	    //对比报警配置
	    NET_SDK_GET_FACE_MATCH_ALARM,//queryFaceMatchAlarm  in:NULL out:NET_SDK_FACE_MATCH_ALARM
	    NET_SDK_SET_FACE_MATCH_ALARM,//editFaceMatchAlarm in:NET_SDK_FACE_MATCH_ALARM out:NULL
	    //请求人脸目标图片
	    NET_SDK_GET_FACE_INFO_IMG,//requestFacePersonnalInfoImage in:NET_SDK_FACE_INFO_IMG_GET out:NET_SDK_FACE_INFO_IMG_DATA
	    //以图搜图 searchImageByImage
	    NET_SDK_SEARCH_IMAGE_BY_IMG, //searchImageByImage in:NET_SDK_SEARCH_IMAGE_BY_IMAGE out:NET_SDK_SEARCH_IMAGE_BY_IMAGE_LIST
	    //查询通道人脸图片
	    NET_SDK_SEARCH_CH_SNAP_FACE_IMG_LIST,//queryChSnapFaceImageList in:NET_SDK_CH_SNAP_FACE_IMG_LIST_SEARCH out:NET_SDK_CH_SNAP_FACE_IMG_LIST
	    //请求通道人脸图片数据
	    NET_SDK_SEARCH_CH_SNAP_FACE_IMG,//requestChSnapFaceImage in:NET_SDK_FACE_IMG_INFO_CH out:NET_SDK_FACE_INFO_IMG_DATA
	}
	boolean NET_SDK_FaceMatchOperate(NativeLong lUserID, int dwCommand, Pointer lpInBuffer, int dwInBufferSize,
			Pointer lpOutBuffer, int dwOutBufferSize, IntByReference lpBytesReturned);
	// 画面叠加字符和图像
	boolean NET_SDK_RegisterDrawFun(NativeLong lLiveHandle, DRAW_FUN_CALLBACK fDrawFun, Pointer pUser);
    // 设置智能分析事件上报回调。
	boolean NET_SDK_SetSubscribCallBack(SUBSCRIBE_CALLBACK fSubscribCallBack, Pointer pUser);
    
    //boolean NET_SDK_ApiInterface(NativeLong lUserID, Pointer sendXML, Pointer strUrl, Pointer lpOutBuffer, int dwOutBufferSize, Pointer lpBytesReturned);
    boolean NET_SDK_TransparentConfig(NativeLong lUserID, String sendXML, String strUrl, 
    		Pointer lpOutBuffer, int dwOutBufferSize, IntByReference lpBytesReturned);
    
    //获取设备的配置信息
  	boolean NET_SDK_GetDVRConfig(NativeLong lUserID, int dwCommand,NativeLong lChannel,Pointer lpOutBuffer, int dwOutBufferSize, Pointer lpBytesReturned,boolean bDefautlConfig);
  	//设置设备的配置信息
  	boolean NET_SDK_SetDVRConfig(NativeLong lUserID, int dwCommand,NativeLong lChannel,Pointer lpInBuffer, int dwInBufferSize);
  	
  	boolean NET_SDK_SmartSubscrib(NativeLong lUserID, int dwCommand, int lChannel, NET_DVR_SUBSCRIBE_REPLY.ByReference pOutBuffer);
  	boolean NET_SDK_UnSmartSubscrib(NativeLong lUserID, int dwCommand, int lChannel, Pointer pInServerAddress, IntByReference dwResult);
  	
  	public static class LLong extends IntegerType {
		private static final long serialVersionUID = 1L;
		
		/** Size of a native long, in bytes. */
	    public static int size;
	    static {
	        size = Native.LONG_SIZE;
	        if (Utils.getOsPrefix().toLowerCase().equals("linux-amd64") 
	        		|| Utils.getOsPrefix().toLowerCase().equals("win32-amd64")) {
	        	size = 8;
	        } else if (Utils.getOsPrefix().toLowerCase().equals("linux-i386") 
	        		|| Utils.getOsPrefix().toLowerCase().equals("win32-x86")) {
	        	size = 4;
	        }
	    } 
	    
	    /** Create a zero-valued LLong. */
	    public LLong() {
	        this(0);
	    }
	    
	    /** Create a LLong with the given value. */
	    public LLong(long value) {
	        super(size, value);
	    }
	}
  	//PTZ
  	boolean NET_SDK_PTZControl(NativeLong lLiveHandle, int dwPTZCommand, int dwSpeed);
  	boolean NET_SDK_PTZControl_Other(NativeLong lUserID, int lChannel, int dwPTZCommand, int dwSpeed);
  	boolean NET_SDK_PTZControl_3D(NativeLong lLiveHandle, int lChannel, PTZ_3D_POINT_INFO pPtz3DInfo);
  	boolean NET_SDK_PTZPreset(NativeLong lLiveHandle, int dwPTZPresetCmd, int dwPresetIndex);
  	boolean NET_SDK_PTZPreset_Other(NativeLong lUserID,int lChannel,int dwPTZPresetCmd,int dwPresetIndex);
  	boolean NET_SDK_PTZSetCruise(NativeLong lLiveHandle,int byCruiseRoute,Pointer pCruisePoint,int pointNum);
  	boolean NET_SDK_PTZSetCruise_Other(NativeLong lUserID, int lChannel, int byCruiseRoute, Pointer pCruisePoint, int pointNum);
  	boolean NET_SDK_PTZCruise(NativeLong lLiveHandle, int dwPTZCruiseCmd, int byCruiseRoute);
  	boolean NET_SDK_PTZCruise_Other(NativeLong lUserID, int lChannel, int dwPTZCruiseCmd, int byCruiseRoute);
  	boolean NET_SDK_PTZTrack(NativeLong lLiveHandle, int dwPTZTrackCmd);
  	boolean NET_SDK_PTZTrack_Other(NativeLong lUserID, int lChannel, int dwPTZTrackCmd);
  	boolean NET_SDK_PTZAutoScan(NativeLong lLiveHandle, int dwPTZAutoScanCmd, int dwSpeed, boolean bIsAutoScan);
  	boolean NET_SDK_PTZAutoScan_Other(NativeLong lUserID, int lChannel, int dwPTZAutoScanCmd);
  	
  	boolean NET_SDK_GetPTZCameraType(NativeLong lUserID, IntByReference pCameraType);//0 不支持云台的枪机 1支持云台的枪机 2支持云台的球机
  	boolean NET_SDK_GetPTZConfig(NativeLong lUserID, int lChannel, int dwCommand, Pointer lpInBuffer, int dwInBufferSize, 
  			Pointer lpOutBuffer, int dwOutBufferSize, IntByReference lpBytesReturned);
  	boolean NET_SDK_GetDeviceSupportFunction(NativeLong lUserID, NET_SDK_DEV_SUPPORT.ByReference pDevSupport);
  	
  	int NET_SDK_StartVoiceCom(NativeLong lUserID, boolean bNeedCBNoEncData, 
  			TALK_DATA_CALLBACK fVoiceDataCallBack, Pointer pUser);
  	boolean NET_SDK_SetVoiceComClientVolume(int lVoiceComHandle, int wVolume);
  	boolean NET_SDK_StopVoiceCom(int lVoiceComHandle);
  	NativeLong NET_SDK_FindDisk(NativeLong lUserID);
  	boolean NET_SDK_GetNextDiskInfo(NativeLong lDiskHandle, NET_SDK_DISK_INFO.ByReference pDiskInfo);
  	boolean NET_SDK_FindDiskClose(NativeLong lDiskHandle);
  	
  	NativeLong NET_SDK_Upgrade(NativeLong lUserID, String sFileName);
  	int NET_SDK_GetUpgradeState(NativeLong lUpgradeHandle);
  	int NET_SDK_GetUpgradeProgress(NativeLong lUpgradeHandle);
  	boolean NET_SDK_CloseUpgradeHandle(NativeLong lUpgradeHandle);
  	NativeLong NET_SDK_UpgradeIPC(NativeLong lUserID, String sFileName,int fileType);
  	
  	NativeLong NET_SDK_FindDVRLog(NativeLong lUserID, int dwType, DD_TIME.ByReference lpStartTime, 
  			DD_TIME.ByReference lpStopTime);
  	int NET_SDK_FindNextLog(NativeLong lLogHandle, NET_SDK_LOG.ByReference lpLogData);
  	boolean NET_SDK_FindLogClose(NativeLong lLogHandle);
  	
  	boolean NET_SDK_RebootDVR(NativeLong lUserID);
  	
  	boolean NET_SDK_ChangTime(NativeLong lUserID, long time);//修改设备系统时间
  	
  	boolean NET_SDK_GetDeviceCHStatus(NativeLong lUserID, Pointer pDeviceCHStatus, NativeLong lBuffSize, Pointer pCHCount);//获取NVR的通道状态
  	
    //动态生成I帧
  	boolean NET_SDK_MakeKeyFrameEx(NativeLong lUserID, int lChannel, int streamType);
    //预览支持码流数
    int NET_SDK_SupportStreamNum(NativeLong lUserID, int lChannel);
    

    boolean NET_SDK_SetLogToFile(boolean bLogEnable, String strLogDir, boolean bAutoDel, int logLevel);
    //P2P2.0配置
    boolean NET_SDK_SetNat2Addr(String sServerAddr, short wDVRPort);
    
    boolean NET_SDK_SetVideoEffect_Ex(NativeLong lUserID,int lChannel,int dwBrightValue,int dwContrastValue,int dwSaturationValue,int dwHueValue);
    boolean NET_SDK_GetVideoEffect_Ex(NativeLong lUserID,int lChannel,
    		NET_SDK_IMAGE_EFFECT_T.ByReference pBrightValue,
    		NET_SDK_IMAGE_EFFECT_T.ByReference pContrastValue,
    		NET_SDK_IMAGE_EFFECT_T.ByReference pSaturationValue,
    		NET_SDK_IMAGE_EFFECT_T.ByReference pHueValue);
    boolean NET_SDK_GetDefaultVideoEffect(NativeLong lUserID,IntByReference pBrightValue,IntByReference pContrastValue,
    		IntByReference pSaturationValue,IntByReference pHueValue);
}
